# ［9.1.1.梁の結合状態］を梁符号（ワイルドカード）で指定

## 本プログラムの説明

本プログラムは、『SS7』で大梁で小梁をモデル化する物件データにおいて、指定した梁符号の鉛直面内の結合状態（［9.1.1.梁の結合状態］）をピンに変更した物件データを新たに生成します。<br>
符号の指定では、厳密に一致する符号で指定することも、カンマで区切って複数の符号を指定することも、ワイルドカードと組み合わせて指定することもできます。<br>

## 本プログラムの実行方法

1. プログラム実行<br>
    1.1.「`g2sb.py`」を実行します。<br>
   　<img src="docs/image/梁の結合01.png" width="60%">

    1.2.物件データのパス名と梁符号を入力します。<br>
   　 複数の梁符号をカンマで区切って指定できます。また、ワイルドカードが指定できます。<br>
   　・$ は英文字一文字（大小区別なし） [A-Za-z]<br>
   　・# は数字一文字 [0-9]

   1.3.［実行］ボタンをクリックします。<br>
   　入力した梁符号に該当する符号がない場合は、その符号を示すメッセージを出力します。<br>
   　この場合［OK］ボタンをクリックすると処理は継続します。

   1.4. 正常に物件データが生成されると以下のメッセージが表示されますので、［OK］ボタンをクリックします。<br>
   　<img src="docs/image/物件作成.png" width="40%">

2. プログラム終了<br>
    「梁の結合状態変更データ作成」ウィンドウの［終了］ボタンをクリックして、プログラムを終了します。

3. 生成されたデータの確認<br>
    入力した物件データと同じレベルに、“_pin”という名前が付加されたデータが生成されます。<br>
    『SS7』を起動し、データを開いて確認してください。

## 注意事項

* 本プログラムは『SS7』Ver.1.1.21.2で動作確認を行いました。<br>
* ［7.15.一本部材-2.梁］のデータは考慮していません。生成されたデータから調整してください。<br>
* 指定した物件データ内に「inp_all.csv」を出力します。同名のCSVファイルがあっても上書きします。<br>
* 結合状態を生成または変更した物件データは、指定した物件データのフォルダ名に「_pin」を付加したフォルダ名になります。すでに同一名称のフォルダがあれば生成（上書き）しません。

## 『Op.Python実行』の設定手順

Ss7Pythonライブラリを使用するための設定手順です。
1. 『SS7』を起動し、[ツール－環境設定－Op.Python実行]画面を表示します。
2. “利用可能なPython言語のバージョン”を選択し、[デスクトップへコピー]ボタンをクリックします。
3. デスクトップにある「Python」フォルダごと、「src」フォルダにコピーします。

## 必要な外部ライブラリ

必要な外部ライブラリはありません。

## 著作者

Copyright (C) 2026 UNION SYSTEM Inc.

## ライセンス

本プログラムは MIT License に基づいています。「LICENSE」を確認してください。
