# 円形鋼管の曲げを考慮した組み合わせ応力度の検討プログラム

## 本プログラムの概要

本プログラムは、円形鋼管の曲げを考慮した組み合わせ応力度をExcelで検討するプログラムです。

『SS7』では円形鋼管の組み合わせ応力度の検討に曲げ応力度σbを考慮しません。これは、せん断応力度が最大となる断面局所では曲げモーメントが0になるためです。しかし、安全性を評価するためにσbを考慮した組み合わせを、Excelで別途検討されているお客様がおられます。

検討するにあたっては、直交方向の曲げモーメントが断面算定結果に出力されていないため、別に設計応力表を出力し、部材の位置と符号を探して該当するケースの値を採用するという非常に煩わしく面倒な作業を要します。

そこで本プログラムは、曲げモーメントを考慮した組み合わせ応力度を検討したい円形鋼管の柱符号と計算結果シートの「S柱断面算定表.csv」と「柱設計応力表.csv」を指定することで、S柱断面算定表の採用応力値の並びに、採用位置とケースに対応した直交方向の曲げモーメントの値を追記して、新たな「S柱断面算定表_追加済.csv」を出力します。さらに、Excelの関数を用いて直交方向の曲げを考慮した応力度と組み合わせ応力度を計算するExcelファイルを出力します。

ケースは長期、地震時を考慮しています。あらかじめ「柱設計応力表.csv」は長期と地震時の結果をマージしておく必要があります。

## 本プログラムの処理内容

「S柱断面算定表.csv」で材料が切り替わるときの“鉄骨 柱頭 Ｆ値　柱脚  Ｆ値”文字列を分割してヘッダー行とし、その下の行は鋼種と材料強度を文字と値に分割して置換します。<br>
指定された符号について「S柱断面算定表.csv」から検索し、該当した箇所に“直交M”ヘッダーを設け、部材位置、危険断面位置、ケースに応じた直交方向の曲げモーメントを「柱設計応力表.csv」から抽出します。<br>
許容圧縮応力度の文字列を文字と数値に分離して置き換えます。それ以外は、元の内容で「S柱断面算定表_追加済.csv」を出力します。<br>
「S柱断面算定表_追加済.csv」と同じ内容をベースにExcelの関数を用いて、軸力、曲げ、せん断の許容応力度と組み合わせ応力度を計算するExcelファイルを出力します。

## 本プログラムの実行方法

### データ準備

『SS7』の計算結果をCSVファイルに出力<br>
『SS7』のシート出力 \[7.断面算定表-7.3.断面算定表（梁・柱・接合部）-7.3.9.S柱\] を開き、ツールバーの［CSV出力］を選び、“値に付く文字の省略”チェックして出力します。<br>
同様に、シート出力 \[6.設計応力-6.12.設計応力（柱）\] を開きケースを“長期”にして、ツールバーの［CSV出力］を選び、“値に付く文字の省略”にチェクして出力します。<br>
続けて設計応力表のケースを“地震時”に切り替えて、ツールバーの［CSV出力］を選び、“値に付く文字の省略”にチェックして、別名で出力します。
設計応力表.csv を作成<br>
長期の設計応力表のCSVファイルと地震時の設計応力表のCSVファイルを一つにまとめた 設計応力表.csv ファイルを作成します。<br>
※ 両方のファイルに先頭にある“APname～計算時間”は重複しても問題ありません。<br>
※ 文字コードは UTF-8 でなく Shift-JIS で保存してください。
パラメーター設定<br>
`ccm.py`をエディタで開き、25行目～30行目の“設定”を調整します。<br>
検討対象の符号を指定します。カンマ区切りで複数指定できます。<br>
各CSVファイルとExcelファイルのパス名を指定します。
```
# ---------- 設定 ----------
symbol_target = "PC2,2C2,2C3"
symbol_targets = [s.strip() for s in symbol_target.split(",")]
s_csv_path = r"C:\enkei_kumiawase\S柱断面算定表.csv"
result_csv_path = r"C:\enkei_kumiawase\S柱断面算定表_追加済.csv"
stress_csv_path = r"C:\enkei_kumiawase\設計応力表.csv"
Excel_path = r"C:\enkei_kumiawase\S柱断面算定表_組み合わせ.xlsx"
```

### プログラム実行

「`ccm.py`」を実行します。

### プログラム終了

正常に動作すると、以下を表示してプログラムは終了します。<br>
“CSV出力完了：S柱断面算定表_追加済.csv”<br>
“Excel出力完了：S柱断面算定表_組み合わせ.xlsx”

## 注意事項

・本プログラムは『SS7』Ver.1.1.21.2で動作確認を行いました。

## 『Op.Python実行』の設定手順

Ss7Pythonライブラリを使用するための設定手順です。
1. 『SS7』を起動し、[ツール－環境設定－Op.Python実行]画面を表示します。
2. “利用可能なPython言語のバージョン”を選択し、[デスクトップへコピー]ボタンをクリックします。
3. デスクトップにある「Python」フォルダごと、「src」フォルダにコピーします。

## 必要な外部ライブラリ

本プログラムではopenpyxl が必要です。<br>
インストールされていなければ“pip install openpyxl”を実行してください。<br>
外部ライブラリのライセンスは「LICENSES\ライセンスについて.txt」を確認してください。

## 著作者

Copyright (C) 2026 UNION SYSTEM Inc.

## ライセンス

本プログラムは MIT License に基づいています。「LICENSE」を確認してください。

## 商標の表記

Microsoft、Excelおよび関連する名称は、米国Microsoft Corporationの米国およびその他の国における登録商標です。
|正式名称|本書での記載|
|----|----|
|Microsoft(R)|Microsoft|
|Excel(R)|Excel|