# 耐震診断の終局強度とF指標の計算

RC長方形柱に対する曲げ終局強度は、耐震診断で用いられるピース断面分割により計算します。<br>
せん断終局強度は、RC造耐震診断基準の“付則1.1 (3)せん断終局強度の算定”により計算します。<br>
また、RC長方形柱のF指標は、RC造耐震診断基準の“3.2.3 靭性指標”、“付則1.2 柱の終局変形”および<br>
“付則1.3 柱の曲げ降伏変形”により計算します。

## 本プログラムの説明

### 機能

『SS7』の建物データを利用して、RC柱の終局強度（曲げ、せん断）とF指標を計算します。<br>
柱の軸力と内法高さおよび標準内法高さは任意の値をユーザーが入力します。

### 入力

* 以下の入力内容（8項目）について入力します。（入力方法は次節で解説します）

| 入力内容 | 入力例 | 備考 |
| - | - | - |
| 物件データの絶対パス | 例. C:\…\物件データ名.ikn | |
| 柱の位置　 階名 | 例. 1F | 結果CSVの"柱部材断面情報"の 階 を指定 |
| 柱の位置　X軸名 | 例. X1 | 結果CSVの"柱部材断面情報"の X軸を指定 |
| 柱の位置　Y軸名 | 例. Y1 | 結果CSVの"柱部材断面情報"の Y軸を指定 |
| 解析方向 | 例. X | < X >：X方向、< Y >：Y方向 |
| 内法高さ (単位：mm) | 例. 2500 | |
| 標準内法高さ (単位：mm) | 例. 2500 | |
| 軸力　　 (単位：kN) | 例. 123.4･･･ | |

なお、[物件データの絶対パス] および [解析方向]は、大文字と小文字を区別しません。
また、[解析方向]、[内法高さ]、[標準内法高さ]  および [軸力]では、不正な値が入力された場合、再入力となります。

### 計算

* 曲げ終局強度の計算手順について（詳細な説明は『Super Build／RC診断』の解説書を参照してください）
  1. ピース断面ごとに中立軸があると仮定し、中立軸Zを算出します。
  2. 上記の1.で求めたそれぞれの中立軸Zを用いて、曲げ終局強度Muを算定します。
  3. 3つの中立軸の中から整合が取れた中立軸Zを探します。
  4. 曲げ終局強度は、整合が取れた中立軸Zを用いた曲げ終局強度Muを採用します。
* せん断終局強度およびF指標の計算の詳細な説明は『Super Build／RC診断』の解説書を参照してください。

### 出力

* 計算ができる場合は、次のような12項目を出力します。
  1. 階名
  2. フレーム名 (解析方向の入力より判別します)
  3. 軸名
  4. 軸力                 (単位：kN)
  5. 柱頭の曲げ終局強度   (単位：kN･m)
  6. 柱脚の曲げ終局強度   (単位：kN･m)
  7. 曲げ終局時せん断力   (単位：kN)
  8. 柱頭のせん断終局強度 (単位：kN)
  9. 柱脚のせん断終局強度 (単位：kN)<br>
  10. せん断終局強度(柱頭と柱脚の平均値) (単位：kN)
  11. F指標
  12. 破壊形式

* 結果CSVのエクスポートについて
　『SS7』結果データをCSV形式で、指定した物件データ内の「Result_Shin.csv」のファイルに出力します。<br>
　 上記のことが正しくできたとき、“結果CSVのエクスポートが成功しました”のメッセージを出力します。

* 結果CSVのエクスポートが成功しても計算ができない場合、次のようなメッセージを出力します。
  1. 柱の鉄筋重心位置（1段目dt）を2倍した長さが柱せいの1/2を超えている場合
  “ピース断面分割において、柱の鉄筋重心位置を2倍した長さが柱せいの1/2を超えています”
  2. ピース断面内に中立軸が無い場合 や、検討対象の柱が見つからない場合
  “曲げ終局強度Muの計算ができませんでした”

## 本プログラムの実行方法

1. プログラム実行:コマンドラインからプログラムを実行します。
　(「python `ファイル名.py`」の形式で実行します)
    ```
    例) C:に「example」というフォルダ名で配置する場合
        cd C:\example\src
        python calcmu.py
    ```
2. 前述の「本プログラムの説明」における入力内容（8項目）をコマンドライン画面上で行います。
    <img src="docs/image/shin2.png" width="57%">
3. データ入力後、結果CSVのエクスポートが成功すると終局強度（曲げ、せん断）とF指標を計算します。
4. 計算が終了すると、指定した柱の位置の“終局強度（曲げ、せん断）”と“F指標”の結果を画面に出力します。

## 注意事項

1. 本プログラムは『SS7』Ver.1.1.21.2で動作確認を行いました。
2. 以下のような建物データを取り扱います。
･ 純RC造の建物データである。
･ [柱の鉄筋位置]の入力方法に“1段目dt”を指定している。（*1）
･ すべての柱に、長方形柱を指定している。
･ すべての柱に、X方向主筋径とY方向主筋径が同じ径を指定している。（*2）
　併せて、主筋降伏点強度もX方向とY方向が同じである。
　柱帯筋は、異形鉄筋または丸鋼を指定している。

    *1：『SS7』の[柱の鉄筋位置]の入力方法に“かぶり”を指定した場合、かぶりを1段目dtと見なします。
    *2：柱の配筋に関する留意点は、次のとおりです。
 　 ･[芯鉄筋あり]の指定にチェックを付けないでください。
 　 ･直交配筋を考慮しません。さらに、寄筋の指定を無視し、常に1段目の主筋を採用します。
 　 ･降伏点強度σyは『SS7』の材料をそのまま利用し、RC造耐震診断基準の材料に準じません。
 　　（異形のときは σy＋49N/mm2と扱わない、丸鋼のときは 294N/mm2と扱わない）
3. 入力内容の[柱の位置 (2.階名、3.X軸名、4.Y軸名)] は、結果CSVファイル“Result_Shin.csv”の「柱部材断面情報」の“階、X軸、Y軸”と同じ文字列を入力してください。

## 『Op.Python実行』の設定手順

Ss7Pythonライブラリを使用するための設定手順です。
1. 『SS7』を起動し、[ツール－環境設定－Op.Python実行]画面を表示します。
2. “利用可能なPython言語のバージョン”を選択し、[デスクトップへコピー]ボタンをクリックします。
3. デスクトップにある「Python」フォルダごと、「src」フォルダにコピーします。

## 必要な外部ライブラリ

必要な外部ライブラリはありません。

## 著作者

Copyright (C) 2026 UNION SYSTEM Inc.

## ライセンス

本プログラムは MIT License に基づいています。「LICENSE」を確認してください。
