# 杭の許容支持力の一覧表をExcelに出力

## 本プログラムの説明

- 杭の許容支持力において、設計指針、工法すべてを組み合わせた結果をMicrosoft Excel（以降Excel）ファイルに出力します。
- 設計指針、工法に応じた先端N値の採用範囲を自動認識し、長期の許容支持力を算出します。
- 杭メーカーの結果との比較や事前に当たりを付ける際の参考値として利用します。

## 本プログラムの実行方法

1. データ準備<br>
杭の許容支持力を自動計算している『SS7』データを用意します（念のためバックアップの作成を推薦します）。
許容支持力の自動計算は、入力項目[13.1.基礎計算条件－1.基本事項－4.検討項目]で指定し、
入力項目[13.2.杭基礎・独立基礎－杭断面－設計支持力－支持力]で“-1”を入力します。
入力項目[13.11.1.地盤符号の登録]で『SoilBase2008』の登録が必要です。

2. パラメータ設定<br>
cal_ra.py ファイルを編集して必要なパラメーターを設定します。

| 変数名 | 説明 | デフォルト |
| - | - | - |
| ss7_version    |『SS7』のバージョン <br>"None"で最新バージョンでの処理になります。 | "1.1.21.1" |
| ss7_path    | 『SS7』データのパス | r"C:\UsrData\Ra_test.ikn" |

3. プログラム実行<br>
    コマンドラインからプログラムを実行します。
    ```
    例) C:に「example」というフォルダ名で配置する場合
        cd C:\example\src
        python cal_ra.py
    ```

4. プログラム処理の流れ<br>
  4.1. 『SS7』データを開き、入力CSVを出力します。<br>
  4.2. 入力CSV「杭の支持力計算」の設計指針、工法、先端N値の採用範囲を登録します。<br>
  4.3. 「断面算定」まで解析します。<br>
  4.4. 結果CSV「杭基礎の支持力算定」の許容支持力の結果より、設計Raを取得します。<br>
  4.5. 許容支持力の結果をExcelファイルに出力します。

<div style="page-break-before:always"></div>

5. 結果の確認<br>
結果は物件データ内に保存されます。

| 結果 | 説明 |
| ---- | ---- |
| out_ra.xlsx | 許容支持力を出力したExcelファイル |

## 注意事項

- 本プログラムは『SS7』Ver.1.1.21.1で動作確認を行いました。

## 『Op.Python実行』の設定手順

Ss7Pythonライブラリを使用するための設定手順です。
1. 『SS7』を起動し、[ツール－環境設定－Op.Python実行]画面を表示します。
2. “利用可能なPython言語のバージョン”を選択し、[デスクトップへコピー]ボタンをクリックします。
3. デスクトップにある「Python」フォルダごと、「src」フォルダにコピーします。

## 必要な外部ライブラリ

以下の外部ライブラリをPython実行環境にインストールしてください。
- openpyxl：Excelの操作ができるパッケージです。
```cmd
pip install openpyxl
```
外部ライブラリのライセンスは「LICENSES\ライセンスについて.txt」を確認してください。

## 著作者

Copyright (C) 2026 UNION SYSTEM Inc.

## ライセンス

本プログラムは MIT License に基づいています。「LICENSE」を確認してください。

## 商標の表記

Microsoft、Excelおよび関連する名称は、米国Microsoft Corporationの米国およびその他の国における登録商標です。

| 正式名称 | 本書での記載 |
| ---- | ---- |
| Microsoft(R) | Microsoft |
| Excel(R) | Excel |
